clear

* Graders grade 3 non-probe "exams" per Stage
* Exams have multiple questions, some regradable and some non-regradable

* Stage 1: 
* 2.1 (regradable) and 2.2 (not regradable)
* Stage 2: 
* 2.3, 2.4 (regradable) and 2.5, 2.6 (not regradable)
* Stage 3: 
* 1.1 (regradable) and 1.2 (not regradable)

* import excel using "\\tsclient\C\Users\anujit\Dropbox\peer grading\results_friday.xls", firstrow
import excel using "C:\Users\anujit\Dropbox\peer grading\results_friday_21Sep2020.xls", firstrow

drop GraderBias GraderVar
* Dropping bias and variance measures from the non-regrading part

gen order=_n

sort order

gen dev_regrade= TrueScore21-GivenScore21
gen dev_noregrade= TrueScore22-GivenScore22
replace dev_regrade= (- GivenScore23 -GivenScore24 +TrueScore23 +TrueScore24)/2 if StageNumber==2
replace dev_noregrade=(- GivenScore25 -GivenScore26 +TrueScore25 +TrueScore26)/2 if StageNumber==2
replace dev_regrade=(- GivenScore11 +TrueScore11)/2  if StageNumber==3
replace dev_noregrade=(- GivenScore12 +TrueScore12)/2  if StageNumber==3


bysort StageNumber: su dev_regrade

bysort StageNumber: su dev_noregrade

egen var_regrade=sd(dev_regrade), by (Grader StageNumber)
replace var_regrade=var_regrade^2

bysort StageNumber: su var_regrade

egen var_noregrade=sd(dev_noregrade), by (Grader StageNumber)
replace var_noregrade=var_noregrade^2


bysort StageNumber: su var_noregrade

/*
tab dev_regrade
tab dev_noregrade
tab dev_regrade if StageNumber==3
tab dev_regrade  StageNumber
tab dev_noregrade  StageNumber
*/

ttest dev_noregrade if StageNumber<=2, by (StageNumber)
* Manpulation does not increase significantly in the non-regradable questions from stage 1->2

ttest dev_regrade if StageNumber<=2, by (StageNumber)
* Manpulation does not increase or exist in the regradable questions from stage 1->2



ttest dev_noregrade if StageNumber>=2, by (StageNumber)
* Manpulation increases in the non-regradable questions from stage 2->3, topping at around 14%


ttest dev_regrade if StageNumber>=2, by (StageNumber)
* In the third stage manipulation is at a highest of 16%

gen  Stage2TrueScore_regrade= TrueScore23+ TrueScore24
gen  Stage2TrueScore_noregrade= TrueScore25+ TrueScore26


ttest dev_regrade if StageNumber>=2 & (TrueScore11==2 | Stage2TrueScore_regrade ==2), by (StageNumber)
* testing Stage 2 vs Stage 3, conditional on true grade being 2/2, still significant



ttest dev_regrade== dev_noregrade if StageNumber==2
* Manipulation across regarde and no_regrade are not significantly different

ttest dev_regrade== dev_noregrade if StageNumber==3
* 15% vs 14% average under-assignment of grades


ttest dev_regrade== dev_noregrade if StageNumber==3 &  TrueScore11==2 & TrueScore12==2

*egen total_true=max(Total), by (Grader)
*spearman total_true dev_regrade if  StageNumber==3
* no correlation between manipulation and own_grade


* We can test for TRUPEQA mechanism from the regrading requests part of the data
gen err_round3=TrueScore11- TrupeqaScore11_trun 
su err_round3, detail
tab err_round3
* Just 1/42 third round data (with regrading requests) have 25% grading error in assigned score before regrading requests, rest are doing fine.
* Comparing with the median session, the error is significantly smaller, with the two-tailed P value equals 0.0057 




egen TRUPEQA =  rowtotal (TrupeqaScore21_trun  TrupeqaScore11_trun  TrupeqaScore2324_trun), missing
cdfplot TRUPEQA, by ( StageNumber ) ytitle(CDF) xtitle(TRUPEQA transfers) legend(order(1 "Stage 1" 2 "Stage 2" 3 "Stage 3" ))
graph export "\\tsclient\C\Users\anujit\Dropbox\peer grading\Graphs\CDF trupeqa transfer.pdf", as(pdf) replace


egen GraderBias =  rowtotal (GraderBias1  GraderBias2  GraderBias3), missing
replace GraderBias=-GraderBias
cdfplot GraderBias, by ( StageNumber ) ytitle(CDF) xtitle(GraderBias) legend(order(1 "Stage 1" 2 "Stage 2" 3 "Stage 3" ))
graph export "\\tsclient\C\Users\anujit\Dropbox\peer grading\Graphs\GraderBias.pdf", as(pdf) replace

egen GraderVar =  rowtotal (GraderVar1  GraderVar2  GraderVar3), missing
cdfplot GraderVar, by ( StageNumber ) ytitle(CDF) xtitle(GraderVar) legend(order(1 "Stage 1" 2 "Stage 2" 3 "Stage 3" ))
graph export "\\tsclient\C\Users\anujit\Dropbox\peer grading\Graphs\GraderVar.pdf", as(pdf) replace



tab RegradinginStage1
tab RegradinginStage2
tab RegradinginStage3
* number of regrading requests 2, 2, 3
